﻿using System;
using System.Configuration;

namespace AppSensor2.configuration
{
    public class EmailSmsElement : ConfigurationElement
    {
        /**
       * Retrieves the protocol to use when sending to clients
       * @return the protocol to use when sending to clients
       */
        [ConfigurationProperty("protocol", DefaultValue = "smtp")]
        public String Protocol
        {
            get { return (string)this["protocol"]; }
            set { this["protocol"] = value; }
        }

        /**
         * Retrieves the host to use when sending to clients
         * @return the host to use when sending to clients
         */
        [ConfigurationProperty("host", IsRequired = true)]
        public String Host
        {
            get { return (string)this["host"]; }
            set { this["host"] = value; }
        }

        /**
         * Retrieves the port to use when sending to clients
         * @return the port to use when sending to clients
         */
        [ConfigurationProperty("port", DefaultValue = 25)]
        public int Port
        {
            get { return (int)this["port"]; }
            set { this["port"] = value; }
        }

        /**
         * Retrieves whether or not the host requires authentication when sending to clients
         * @return whether or not the host requires authentication when sending to clients
         */
        [ConfigurationProperty("authenticationrequired", DefaultValue = false)]
        public bool AuthenticationRequired
        {
            get { return (bool)this["authenticationrequired"]; }
            set { this["authenticationrequired"] = value; }
        }

        /**
         * Retrieves the authenticating user to use when sending to clients
         * @return the authenticating user to use when sending to clients
         */
        [ConfigurationProperty("authenticationuser")]
        public String AuthenticationUser
        {
            get { return (string)this["authenticationuser"]; }
            set { this["authenticationuser"] = value; }
        }

        /**
         * Retrieves the authenticating password to use when sending to clients
         * @return the authenticating password to use when sending to clients
         */
        [ConfigurationProperty("authenticationpassword")]
        public String AuthenticationPassword
        {
            get { return (string)this["authenticationpassword"]; }
            set { this["authenticationpassword"] = value; }
        }

        /**
         * Retrieves the from account to use when sending to clients
         * @return the from account to use when sending to clients
         */
        [ConfigurationProperty("from")]
        public String FromAccount
        {
            get { return (string)this["from"]; }
            set { this["from"] = value; }
        }

        /**
         * Retrieves the to account(s) to use when sending to clients
         * @return the to account(s) to use when sending to clients
         */
        [ConfigurationProperty("to", IsRequired = true)]
        public string ToAccounts
        {
            get { return (string)this["to"]; }
            set { this["to"] = value; }
        }
    }
}
